/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.util.Properties;

import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;

/**
 * This is a wrapper class which allows to print a engine
 */
public class PrintEngineReportData implements RenderData {

    private Engine eng;
    private String requestURL = "";

    /**
     * Constructor of the wrapper class, sets the engine
     * @param engine that will be printed
     */
    public PrintEngineReportData( Engine engine ) {
        eng = engine;
    }

    /**
     * Function not needed to print
     * @param arg0 not used
     */
    public void setReportName( String arg0 ) {
    }

    /**
     * Function not needed to print
     * @return null
     */
    public String getReportName() {
        return null;
    }

    //wrapper function returns the page data
    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] getPageData( int page ) {
        try {
            return eng.getPageData( page );
        } catch( ReportException e ) {
            throw ViewerException.createViewerException( e );
        }
    }

    //wrapper function returns the page count
    /**
     * {@inheritDoc}
     */
    @Override
    public int getPageCount() {
        try {
            return eng.getPageCount();
        } catch( ReportException e ) {
            throw ViewerException.createViewerException( e );
        }
    }

    //function not needed to print
    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] getNextExportChunk() {
        return null;
    }

    //function not needed to print
    /**
     * {@inheritDoc}
     */
    @Override
    public int getExportChunkCount( Properties arg0 ) {
        return 0;
    }

    //wrapper function returns the group tree
    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] getGroupTree() {
        try {
            return eng.getGroupTree();
        } catch( ReportException e ) {
            throw ViewerException.createViewerException( e );
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setReportTitle( String title ) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getReportTitle() {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final void setReportProperty( String key, String value ) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final Properties getProperties() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public final String getReportProperty( String key ) {
        return "";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setPromptOnRefresh( boolean promptOnRefresh ) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isPromptOnRefresh() {
        return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setReportLocation( String name ) {
        requestURL = name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getReportLocation() {
        return requestURL;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] refreshPageData( int page ) throws ViewerException {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RenderData getCopy() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void stop() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] search( String phrase, int startPage, int flags ) {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public byte[] getFontData( int fontID ) {
        return eng.getFontData( fontID );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void resetServerCacheTimeout() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isPageLimitExceeded() {
        return false;
    }
}
